#if !defined(__leowl_1_h) // Sentry, use file only if it's not already included.
#define __leowl_1_h

/*  Project leowl_1
	 xor@frognet.net
	 Copyright  1996. Andrey B. Yastrebov. All Rights Reserved.

	 SUBSYSTEM:    leowl_1.exe Application
	 FILE:         leowl_1.h
	 AUTHOR:       Andrey B. Yastrebov


	 OVERVIEW
	 ========
	 Class definition for leowl_1 (TApplication).
*/
#include <owl\owlpch.h>
#pragma hdrstop

#include <classlib\bags.h>

#include "leowl_1.rh"
#include "leowl_1e.h"

// TFileDrop class Maintains information about a dropped file, its name,
// where it was dropped, and whether or not it was in the client area
class TFileDrop {
public:
	 operator == (const TFileDrop& other) const {return this == &other;}

	 char*   FileName;
	 TPoint  Point;
	 BOOL    InClientArea;

	 TFileDrop (char*, TPoint&, BOOL, TModule*);
	 ~TFileDrop ();

	 const char* WhoAmI ();
private:
	 //
	 // hidden to prevent accidental copying or assignment
	 //
	 TFileDrop (const TFileDrop&);
	 TFileDrop & operator = (const TFileDrop&);
};

typedef TIBagAsVector<TFileDrop> TFileList;
typedef TIBagAsVectorIterator<TFileDrop> TFileListIter;

//{{TApplication = leowl_1}}
class leowl_1 : public TApplication {
public:
	 leowl_1 ();
	 virtual ~leowl_1 ();

	 void OpenFile (const char *fileName = 0);
//{{leowl_1VIRTUAL_BEGIN}}
public:
	 virtual void InitMainWindow();
	 virtual void InitInstance();
	 virtual BOOL CanClose ();
//{{leowl_1VIRTUAL_END}}

//{{leowl_1RSP_TBL_BEGIN}}
protected:
	 void CmHelpAbout ();
	 void EvDropFiles (TDropInfo drop);
	 void CmDesktopRestore ();
	 void CmDesktopSave ();
//{{leowl_1RSP_TBL_END}}
DECLARE_RESPONSE_TABLE(leowl_1);
DECLARE_STREAMABLE(,leowl_1,1);
}; //{{leowl_1}}

#endif // __leowl_1_h sentry.
